/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.preferences;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.ui.internal.preferences.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GitPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        FileFieldEditor fileEditor = new FileFieldEditor("git_executable_path", Messages.GitExecutableLocationPage_LocationLabel, true, 0, this.getFieldEditorParent()){

            protected boolean checkState() {
                boolean ok = super.checkState();
                if (!ok) {
                    return ok;
                }
                String text = this.getTextControl().getText();
                if (text != null && text.trim().length() > 0 && !GitExecutable.acceptBinary((IPath)Path.fromOSString((String)text))) {
                    this.showErrorMessage(NLS.bind((String)Messages.GitExecutableLocationPage_InvalidLocationErrorMessage, (Object)"1.6.0"));
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        this.addField((FieldEditor)fileEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("git_calculate_pull_indicator", Messages.GitExecutableLocationPage_CalculatePullIndicatorLabel, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("auto_attach_repos", Messages.GitExecutableLocationPage_AutoAttachProjectsLabel, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("ignore_no_git", Messages.GitPreferencePage_IgnoreMissingGitLabel, this.getFieldEditorParent()));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, GitPlugin.getPluginId());
    }
}

